/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.core;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEqualTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsEqual.equalTo((Object)"irrelevant");
    }

    public void testComparesObjectsUsingEqualsMethod() {
        MatcherAssert.assertThat((Object)"hi", (Matcher)IsEqual.equalTo((Object)"hi"));
        MatcherAssert.assertThat((Object)"bye", (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)"hi")));
        MatcherAssert.assertThat((Object)1, (Matcher)IsEqual.equalTo((Object)1));
        MatcherAssert.assertThat((Object)1, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)2)));
    }

    public void testCanCompareNullValues() {
        MatcherAssert.assertThat(null, (Matcher)IsEqual.equalTo(null));
        MatcherAssert.assertThat(null, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)"hi")));
        MatcherAssert.assertThat((Object)"hi", (Matcher)IsNot.not((Matcher)IsEqual.equalTo(null)));
    }

    public void testHonoursIsEqualImplementationEvenWithNullValues() {
        Object alwaysEqual = new Object(){

            public boolean equals(Object obj) {
                return true;
            }
        };
        Object neverEqual = new Object(){

            public boolean equals(Object obj) {
                return false;
            }
        };
        MatcherAssert.assertThat((Object)alwaysEqual, (Matcher)IsEqual.equalTo(null));
        MatcherAssert.assertThat((Object)neverEqual, (Matcher)IsNot.not((Matcher)IsEqual.equalTo(null)));
    }

    public void testComparesTheElementsOfAnObjectArray() {
        String[] s1 = new String[]{"a", "b"};
        String[] s2 = new String[]{"a", "b"};
        String[] s3 = new String[]{"c", "d"};
        String[] s4 = new String[]{"a", "b", "c", "d"};
        MatcherAssert.assertThat((Object)s1, (Matcher)IsEqual.equalTo((Object)s1));
        MatcherAssert.assertThat((Object)s2, (Matcher)IsEqual.equalTo((Object)s1));
        MatcherAssert.assertThat((Object)s3, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)s1)));
        MatcherAssert.assertThat((Object)s4, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)s1)));
    }

    public void testComparesArraysToNull() {
        MatcherAssert.assertThat((Object)new String[]{"a", "b"}, (Matcher)IsNot.not((Matcher)IsEqual.equalTo(null)));
        MatcherAssert.assertThat(null, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)new String[]{"a", "b"})));
    }

    public void testComparesTheElementsOfAnArrayOfPrimitiveTypes() {
        int[] i1 = new int[]{1, 2};
        int[] i2 = new int[]{1, 2};
        int[] i3 = new int[]{3, 4};
        int[] i4 = new int[]{1, 2, 3, 4};
        MatcherAssert.assertThat((Object)i1, (Matcher)IsEqual.equalTo((Object)i1));
        MatcherAssert.assertThat((Object)i2, (Matcher)IsEqual.equalTo((Object)i1));
        MatcherAssert.assertThat((Object)i3, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)i1)));
        MatcherAssert.assertThat((Object)i4, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)i1)));
    }

    public void testRecursivelyTestsElementsOfArrays() {
        int[][] i1 = new int[][]{{1, 2}, {3, 4}};
        int[][] i2 = new int[][]{{1, 2}, {3, 4}};
        int[][] i3 = new int[][]{{5, 6}, {7, 8}};
        int[][] i4 = new int[][]{{1, 2, 3, 4}, {3, 4}};
        MatcherAssert.assertThat((Object)i1, (Matcher)IsEqual.equalTo((Object)i1));
        MatcherAssert.assertThat((Object)i2, (Matcher)IsEqual.equalTo((Object)i1));
        MatcherAssert.assertThat((Object)i3, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)i1)));
        MatcherAssert.assertThat((Object)i4, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)i1)));
    }

    public void testIncludesTheResultOfCallingToStringOnItsArgumentInTheDescription() {
        String argumentDescription = "ARGUMENT DESCRIPTION";
        Object argument = new Object(){

            public String toString() {
                return "ARGUMENT DESCRIPTION";
            }
        };
        IsEqualTest.assertDescription("<ARGUMENT DESCRIPTION>", IsEqual.equalTo((Object)argument));
    }

    public void testReturnsAnObviousDescriptionIfCreatedWithANestedMatcherByMistake() {
        Matcher innerMatcher = IsEqual.equalTo((Object)"NestedMatcher");
        IsEqualTest.assertDescription("<" + innerMatcher.toString() + ">", IsEqual.equalTo((Object)innerMatcher));
    }

    public void testReturnsGoodDescriptionIfCreatedWithNullReference() {
        IsEqualTest.assertDescription("null", IsEqual.equalTo(null));
    }
}

